$files = Get-ChildItem -Path "c:\Users\Nirmala Perera\Desktop\RML" -Filter "*.html" -Recurse

foreach ($file in $files) {
    $content = Get-Content $file.FullName -Raw -Encoding UTF8
    
    # Check if the file has the Google Translate initialization
    if ($content -match 'function googleTranslateElementInit\(\)') {
        Write-Host "Updating: $($file.FullName)"
        
        # Replace the simple configuration with enhanced configuration
        $content = $content -replace "new google\.translate\.TranslateElement\(\{ pageLanguage: 'en' \}, 'google_translate_element'\);", 
        "new google.translate.TranslateElement({`r`n                pageLanguage: 'en',`r`n                includedLanguages: 'en,es,fr,de,it,pt,ru,zh-CN,ja,ko,ar,hi,ta,si',`r`n                layout: google.translate.TranslateElement.InlineLayout.SIMPLE,`r`n                autoDisplay: false`r`n            }, 'google_translate_element');"
        
        # Save the file
        [System.IO.File]::WriteAllText($file.FullName, $content, [System.Text.Encoding]::UTF8)
        Write-Host "Updated: $($file.FullName)"
    }
}

Write-Host "`nAll files have been updated with enhanced Google Translate configuration!"
