$filesToFix = @(
    "c:\Users\Nirmala Perera\Desktop\RML\tours\sigiriya.html",
    "c:\Users\Nirmala Perera\Desktop\RML\tours\polgampola.html",
    "c:\Users\Nirmala Perera\Desktop\RML\tours\whale-watching.html",
    "c:\Users\Nirmala Perera\Desktop\RML\tours\ella.html",
    "c:\Users\Nirmala Perera\Desktop\RML\activities\beach.html",
    "c:\Users\Nirmala Perera\Desktop\RML\activities\paramotoring.html",
    "c:\Users\Nirmala Perera\Desktop\RML\activities\visiting-deepsea.html"
)

$scriptToAdd = @"
    <script type="text/javascript">
    function googleTranslateElementInit() {
      new google.translate.TranslateElement({pageLanguage: 'en'}, 'google_translate_element');
    }
    </script>
    <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
</head>
"@

foreach ($file in $filesToFix) {
    try {
        # Read with UTF8 encoding
        $content = [System.IO.File]::ReadAllText($file, [System.Text.Encoding]::UTF8)
        
        # Check if script is already added
        if ($content -notmatch "googleTranslateElementInit") {
            # Add script before </head>
            $content = $content -replace '</head>', $scriptToAdd
            
            # Write back with UTF8 encoding
            [System.IO.File]::WriteAllText($file, $content, [System.Text.Encoding]::UTF8)
            Write-Host "Updated: $file"
        }
        else {
            Write-Host "Already updated: $file"
        }
    }
    catch {
        Write-Host "Error processing $file : $_"
    }
}

Write-Host "Completed fixing encoding issues!"
