$files = Get-ChildItem -Path "c:\Users\Nirmala Perera\Desktop\RML" -Filter "*.html" -Recurse

foreach ($file in $files) {
    $content = Get-Content $file.FullName -Raw -Encoding UTF8
    $originalContent = $content
    
    # Count how many google_translate_element divs exist
    $matches = [regex]::Matches($content, '<div id="google_translate_element"></div>')
    
    if ($matches.Count -gt 1) {
        Write-Host "Fixing duplicates in: $($file.FullName) - Found $($matches.Count) instances"
        
        # First, remove ALL instances of the google translate element
        $content = $content -replace '\s*<li><div id="google_translate_element"></div></li>\r?\n?', ''
        $content = $content -replace '\s*<div id="google_translate_element"></div>\r?\n?', ''
        
        # Now add it back ONCE at the end of nav-links, before </ul>
        # Find the nav-links section and add it there
        if ($content -match '(<ul class="nav-links">[\s\S]*?)(</ul>)') {
            $content = $content -replace '(<ul class="nav-links">[\s\S]*?)(</ul>)', "`$1                <li><div id=`"google_translate_element`"></div></li>`r`n            `$2"
        }
        
        # Save the file
        [System.IO.File]::WriteAllText($file.FullName, $content, [System.Text.Encoding]::UTF8)
        Write-Host "Fixed: $($file.FullName)"
    }
    elseif ($matches.Count -eq 0) {
        Write-Host "No translate element found in: $($file.FullName)"
    }
    else {
        Write-Host "OK: $($file.FullName) - Has exactly 1 instance"
    }
}

Write-Host "`nAll files have been checked and fixed!"
