$files = Get-ChildItem -Path "c:\Users\Nirmala Perera\Desktop\RML" -Filter "*.html" -Recurse | Where-Object { $_.Name -ne "index.html" }

foreach ($file in $files) {
    $content = Get-Content $file.FullName -Raw -Encoding UTF8
    
    # Check if the file has the Google Translate element in the wrong position
    if ($content -match '<div id="google_translate_element"></div>\s*<a href') {
        Write-Host "Fixing: $($file.FullName)"
        
        # Remove the Google Translate element from its current position
        $content = $content -replace '\s*<div id="google_translate_element"></div>\r?\n', ''
        
        # Add it at the end of nav-links, before the closing </ul>
        $content = $content -replace '(\s*</ul>)', "`r`n                <li><div id=`"google_translate_element`"></div></li>`r`n`$1"
        
        # Save the file
        [System.IO.File]::WriteAllText($file.FullName, $content, [System.Text.Encoding]::UTF8)
        Write-Host "Fixed: $($file.FullName)"
    }
}

Write-Host "All files have been updated!"
